/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.perks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.perk.Perk;
import dev.toma.gunsrpg.common.perk.PerkRegistry;
import dev.toma.gunsrpg.common.perk.PerkValueSpec;
import dev.toma.gunsrpg.resource.adapter.PerkAdapter;
import dev.toma.gunsrpg.resource.adapter.PerkValueSpecAdapter;
import dev.toma.gunsrpg.resource.perks.PerkConfigurationLoader;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PerkManager
extends JsonReloadListener {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Perks");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Perk.class, (Object)new PerkAdapter()).registerTypeAdapter(PerkValueSpec.class, (Object)new PerkValueSpecAdapter()).create();
    public final PerkConfigurationLoader configLoader = new PerkConfigurationLoader();

    public PerkManager() {
        super(GSON, "perks");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, IResourceManager resourceManager, IProfiler profiler) {
        GunsRPG.log.info(MARKER, "Loading perks");
        PerkRegistry registry = PerkRegistry.getRegistry();
        registry.dropRegistry();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            this.loadPerk(entry.getKey(), entry.getValue(), registry);
        }
        registry.finishRegistering();
        GunsRPG.log.info(MARKER, "Perks loaded, total {}", (Object)registry.size());
    }

    private void loadPerk(ResourceLocation id, JsonElement data, PerkRegistry registry) {
        try {
            Perk perk = (Perk)GSON.fromJson(data, Perk.class);
            registry.register(id, perk);
        }
        catch (JsonParseException e) {
            GunsRPG.log.error(MARKER, "Error loading perk {}, {}", (Object)id, (Object)e.toString());
        }
    }
}

